﻿/*
	VERSION:		1.4
	
	PURPOSE:
		This system allows you to easily play sound-effects
		without them interupting each other.
	
	MINIMAL USAGE:
		#include "makeSoundSystem.as"
		SOUND = makeSoundSystem();	
		SOUND.play(linkage);
		
	MAX USAGE:
		#include "makeSoundSystem.as"
		SOUND = makeSoundSystem( target_mc:MovieClip, newName:String, [newDepth:Number] );
		SOUND.play(linkage, [volume]);
		
	FUNCTIONS:
		SOUND.play(linkage, [volume]);		Plays a sound effect, and sets its individual volume.
		SOUND.stopAll();							Stops all currently-playing sound effects.
		
	PROPERTIES
		volume										Changes the overall volume of the sound system.
														(scales every sound's volume, while retaining relative volume levels)
	DEPENDANCIES
		nextDepth.as
*/
makeSoundSystem = function(target_mc, name, depth)
{
	// resolve optional parameters
	target_mc = (target_mc!=undefined) ? target_mc : this;
	name = (target_mc!=undefined) ? name : "soundSystem_mc";
	#include "nextDepth.as"
	depth = (depth!=undefined) ? depth : nextDepth(target_mc);
	
	// create sound container
	var _this = target_mc.createEmptyMovieClip( name, depth );
	_this.sound_array = new Array();
	_this.soundVolume = 100;
	
	
	
	_this.play = function( soundName, volume )
	{
		var volume = (volume!=undefined) ? volume : 100;		// optional parameter
		
		// Create a useless movieClip for this sound's volume control
		var clipName = "transformClip_"+Math.floor( Math.random()*999 );		// transformClip_315
		var transformClip = _this.createEmptyMovieClip( clipName, nextDepth(_this)  );
		
		// Create a new sound
		var new_sound = new Sound( transformClip );
		_this.sound_array.push( new_sound );
		
		// store a reference to this sound's transformClip
		new_sound.transformClip = transformClip;
		
		// store this sound's volume
		new_sound.volume = volume;
		
		// apply volume
		new_sound.setVolume( new_sound.volume * (_this.soundVolume/100) );		// this sound's volume * global volume
		
		// define the sound effect
		new_sound.attachSound( soundName );
		
		// play the sound
		new_sound.start();
		
		
		
		new_sound.remove = function()
		{
			// find this sound in the sound_array
			for (var i=0; i<_this.sound_array.length; i++)
			{
				if( this == _this.sound_array[i] )
				{
					// erase this sound's transformClip
					_this.sound_array[i].transformClip.removeMovieClip();
					
					// splice out this sound
					_this.sound_array.splice( i, 1 );
					
					// stop searching
					break;
				}// if:  this sound is found in the array
			}// for:  sound_array
		}// remove()
		
		
		
		// remove the sound object when it's done playing
		new_sound.onSoundComplete = function()
		{
			_this[nam].stop();
			new_sound.remove();
		}// onSoundComplete()
	}// play()
	
	
	
	_this.stopAll = function()
	{
		// empty the sound_array
		for( var nam in _this.sound_array)
		{
			_this.sound_array[nam].stop();
			_this.sound_array.pop();
		}// for...in:  sound_array
	}// stopAll()
	
	
	
	_this.setVolume = function( newVolume )
	{
		// store the new volume
		_this.soundVolume = newVolume;
		
		// update currently playing sounds
		for( var i=0; i< _this.sound_array.length; i++)
		{
			_this.sound_array[i].setVolume( _this.sound_array[i].volume * (_this.soundVolume/100) );
		}// for:  sound_array
	}// setVolume()
	_this.getVolume = function()
	{
		return _this.soundVolume;
	}// setVolume()
	_this.addProperty( "volume", _this.getVolume, _this.setVolume );
	
	
	
	return _this;
}// makeSoundSystem()
